#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules;
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_BrokenRules : BaseTest 
	{
		private const string TestFormClassName = BROKEN.LabelPrinterConfig.FormClassName;
		private const string TestRuleSet = BROKEN.LabelPrinterConfig.RuleSets.BaseRuleSet;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();
		}

		[Test]
		public void GetBrokenRules_Pass()
		{
			Assert.IsTrue( BrokenRules.GetBrokenRules( TestFormClassName, TestRuleSet ).Length > 0 );
		}
		
		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetBrokenRules_Fail_1()
		{
			BrokenRules.GetBrokenRules( null, TestRuleSet );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetBrokenRules_Fail_2()
		{
			BrokenRules.GetBrokenRules( TestFormClassName, null );
		}

		[Test]
		public void GetBrokenRulesValidationMessages_Pass()
		{
			Assert.IsTrue( BrokenRules.GetBrokenRulesValidationMessages().Rows.Count > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBrokenRulesValidationMessages_Fail() {}
	}
}

#endif
